using System.Diagnostics.CodeAnalysis;
using HarmonyLib;
using UnityEngine;

namespace CrowdControl.Harmony
{
    [HarmonyPatch]
    [SuppressMessage("ReSharper", "InconsistentNaming")]
    public static class CameraFlip
    {
        public static bool Enabled;

        //Camera.FireOnPreCull(Camera cam)
        [HarmonyPrefix]
        [HarmonyPatch(typeof(Camera), "FireOnPreCull")]
        public static void FireOnPreCull(Camera __instance)
        {
            if (!Enabled) return;
            if (__instance != Camera.main) return;

            GL.invertCulling = true;
            Shader.SetGlobalInt("_Cull", (int)UnityEngine.Rendering.CullMode.Off);
        }

        //Camera.FireOnPostRender(Camera cam)
        [HarmonyPostfix]
        [HarmonyPatch(typeof(Camera), "FireOnPostRender")]
        public static void FireOnPostRender(Camera __instance)
        {
            if (!Enabled) return;
            if (__instance != Camera.main) return;

            Shader.SetGlobalInt("_Cull", (int)UnityEngine.Rendering.CullMode.Back);
            GL.invertCulling = false;
        }
    }
}